function [cellid1,sig1]=GFPcallcells_mr(filename,maski)
%using segmented images, call barcodes from cells. 
dic='GTACN';
  
cellid1=unique(maski(:));
cellid1=cellid1(cellid1~=0);
  
if ~isempty(cellid1)
    files=dir(['*',filename,'*.tif']);
    files=sort_nat({files.name});
    info=imfinfo(files{1});
    
    im=zeros(info(1).Height,info(1).Width,4);
    for i=1:length(files)
        for n=1:4
            im(:,:,n,i)=imread(files{i},n);
        end
    end
    im1=reshape(im,size(im,1)*size(im,2),4,[]);
    
    maski1=reshape(maski,[],1);
    
    %read signal
    
    sig1=zeros(size(cellid1,1),size(im1,2),size(im1,3));
    for i=1:size(sig1,1)
        sig1(i,:,:)=mean(im1(maski1==cellid1(i),:,:));
    end
        
else
    sig1=[];
end
end


